package cn.com.duiba.supplier.channel.service.api.dto.request.cnpc;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 盛马-中石油
 *
 * @author wangguanhua
 */
@Data
public class ShengmaCnpcReq implements Serializable {

    private static final long serialVersionUID = -7513012244987966659L;

    /**
     * 充值账号
     */
    @NotBlank(message = "account 不能为空")
    private String account;

    /**
     * 商品编号
     */
    @NotNull(message = "productId 不能为空")
    private String productId;

    /**
     * 商户 id
     */
    private String mchId;
}
