package cn.com.duiba.supplier.channel.service.api.dto.response.alipay;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/27 14:37
 */
@Data
public class AlipayCouponCardNotifyResp implements Serializable {
    
    private static final long serialVersionUID = 3903467546971433462L;

    /**
     * 活动ID
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 优惠券ID
     */
    private String voucherId;

    /**
     * 领取用户ID
     */
    private String userId;

    /**
     * 映射user_id
     */
    private String openId;

    /**
     * 核销时间（Unix时间戳，毫秒）
     */
    private String useTime;

    /**
     * 核销金额（分）
     */
    private String useAmount;

    /**
     * 券消息类型，包括：券发放(V_BATCH_PUBLISH)、券过期(V_EXPIRE)，券删除(V_DELETE)、券核销（V_USE）、券退款（V_REFUND）
     */
    private String bizType;

    /**
     * 退款时间（Unix时间戳，毫秒），仅当券消息类型为“券退款”时返回
     */
    private String refundTime;

    /**
     * 退款金额（分），仅当券消息类型为“券退款”时返回
     */
    private String refundAmount;

    /**
     * 券状态，可用（ENABLED）/不可用（DISABLED）
     */
    private String voucherStatus;

    /**
     * 幂等ID，仅当券消息类型为“券发放”时返回
     */
    private String orderId;

    /**
     * 支付宝交易号
     */
    private String tradeNo;

    /**
     * 券领取时间（Unix时间戳，毫秒），仅当券消息类型为“券发放”时返回
     */
    private String gmtVoucherCreate;

    /**
     * 券删除时间（Unix时间戳，毫秒），仅当券消息类型为“券删除”时返回
     */
    private String deleteTime;

    /**
     * 发放金额（分），仅当券消息类型为“券发放”时返回
     */
    private String publishAmount;

    /**
     * 券过期时间（Unix时间戳，毫秒），仅当券消息类型为“券过期”时返回
     */
    private String expireTime;

    /**
     * 原回调信息
     */
    private String body;
}
