package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * GuMingNotifyStatusEnum
 *
 * @author fmk
 * @since 2024/7/12
 */
@RequiredArgsConstructor
@Getter
public enum GuMingNotifyStatusEnum {

    CONFIRM("CONFIRM", "核销"),
    ROLLBACK("ROLLBACK", "撤销核销");

    private final String code;

    private final String desc;

    public static GuMingNotifyStatusEnum getByCode(String code) {
        for (GuMingNotifyStatusEnum value : values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }
}
