package cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor;


import cn.com.duiba.supplier.channel.service.api.enums.wx.WxBillTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 微信账单下载请求参数
 * @author lyj
 */
@Data
public class WxDownLoadRequest implements Serializable {

    private static final long serialVersionUID = -825188008527628228L;
    /**
     * 下载链接
     */
    private String url;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 批次ID
     */
    private String stockId;
    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 微信账单状态
     * @see WxBillTypeEnum
     */
    private Integer wxBillType;

    /**
     * 微信立减金账单下载记录id
     */
    private Long billDownloadRecordId;

    /**
     *  微信立减金账单下载回调topic
     */
    private String billDownloadCallbackMqTopic;
    /**
     * 微信立减金账单下载回调tag
     */
    private String billDownloadCallbackMqTag;

    /**
     * 发送的mqTopic
     */
    private String mqTopic;

    /**
     * 发送的mqTag
     */
    private String mqTag;

}
