package cn.com.duiba.supplier.channel.service.api.dto.response.meituancoupon;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CouponBatchDetailDto implements Serializable {

    private static final long serialVersionUID = 5825376807691276323L;
    /**
     * 券批次ID
     */
    private Long batchId;

    /**
     * 券批次名称
     */
    private String batchName;

    /**
     * 券批次状态
     1-编辑中
     2-待审核
     3-待提交
     4-审核驳回
     5-进行中
     6-已结束
     7-已停用
     8-创建失败
     */
    private Integer batchStatus;

    /**
     * 券类型
     1-立减券
     3-满减券
     4-折扣券
     7-口价券
     */
    private Integer couponType;

    /**
     * 优惠详情
     */
   private DiscountDetaiDto discountDetailDto;

    /**
     * 券展示标题
     */
    private String titleShow;

    /**
     * 券使用限制说明（展示说明）
     */
    private String restrictShow;

    /**
     * 批次有效期结束时间
     */
    private String assignEndTime;

    /**
     * 批次有效期开始时间
     */
    private String validBeginTime;

    /**
     * 券有效期开始时间
     当券有效类型是1、3时，有值
     当券有效期类型是2倒计时，为null
     */
    private String beginTime;

    /**
     * 券有效期结束时间
     当券有效类型是1、3时，有值
     当券有效期类型是2倒计时，为null
     */
    private String endTime;

    /**
     * 券有效期类型
     1.只有结束时间 2.倒计时时间 3.开始和结束时间
     */
    private Integer usableTimeType;

    /**
     * 倒计时天数
     当券有效期类型是2倒计时，倒计时天数等于券有效期天数
     */
    private Integer countDownDays;

    /**
     * 发券形式
     1-系统发放
     2-兑换码
     */
    private Integer bindType;

    /**
     * 领取限制详情
     */
   private ReceiveLimitDto receiveLimitDto;

    /**
     * 券库存总张数
     */
    private Integer totalCount;

    /**
     * 已发张数
     */
    private Integer sendCount;

    /**
     * 已用张数
     */
    private Integer usedCount;

}
