package cn.com.duiba.supplier.channel.service.api.dto.response.supplier;

import cn.com.duiba.supplier.channel.service.api.enums.channel.ShenBianYunSigningTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: LuHui
 * @date: 2024/4/16 15:04
 * @description:
 */
@Data
public class ShenbianyunSigningDto implements Serializable {

    private static final long serialVersionUID = -6830069268734775204L;

    /**
     * 用户姓名
     */
    private String name;

    /**
     * 银行卡号/支付宝账号（手机号或邮箱）/微信 openid
     */
    private String cardNo;

    /**
     * 身份证号（年龄限制一般为 18-65）
     */
    private String idCard;

    /**
     * 银行预留手机号（四要素会校验手机号真实性、其他目前只校验格式（^(1[2,3,4,5,6,7,8,9][0-9])\d{8}$）
     */
    private String mobile;

    /**
     * 签约状态 0：未签约 1：已签约 2：未检索到个体工商业者信息 3：签约中 4：签约失败
     * @see ShenBianYunSigningTypeEnum
     */
    private Integer state;

    /**
     * 失败原因
     */
    private String retMsg;

}
