package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * ChongDaCodeEnum
 *
 * @author fmk
 * @since 2024/1/25
 */
@RequiredArgsConstructor
@Getter
public enum ChongDaCodeEnum {

    SUCCESS("0000", "交易成功"),
    PARAM_ERROR("0001", "参数错误，下单时可作失败处理，查询订单时不能作失败处理"),
    MD5_VERIFY_FAILED("0002", "MD5 验签失败，下单时可作失败处理，查询订单时不能作失败处理"),
    ILLEGAL_IP("0003", "请求 IP 非法，下单时可作失败处理，查询订单时不能作失败处理"),
    CHANNEL_NOT_EXIST("0004", "渠道不存在，下单时可作失败处理，查询订单时不能作失败处理"),
    CHANNEL_ABNORMAL("0005", "渠道状态异常，下单时可作失败处理，查询订单时不能作失败处理"),
    INTERFACE_MAINTENANCE("0006", "接口维护中，下单时可作失败处理，查询订单时不能作失败处理"),
    SYSTEM_EXCEPTION("0007", "系统异常，充值类业务请联系客服或通过订单查询接口检测订单，避免损失"),
    PROVIDER_EXCEPTION("0008", "提供商异常，下单时可作失败处理，查询订单时不能作失败处理"),
    TIMEOUT("0009", "链接超时，充值类业务请联系客服或通过订单查询接口检测订单，避免损失"),
    ROUTE_NOT_FOUND("0010", "未找到路由信息，下单、查询可作失败处理"),
    CHANNEL_BALANCE_INSUFFICIENT("1000", "渠道余额不足，下单时可作失败处理"),
    ORDER_ALREADY_EXIST("1001", "订单已存在，重复提交时下单时不能作失败处理，可通过查询接口"),
    ORDER_NOT_EXIST("1002", "订单不存在，查询订单时，超过 3 分钟前的订单可作失败处理"),
    PRODUCT_NOT_AVAILABLE("1003", "产品未上架，下单、查询可作失败处理"),
    INSUFFICIENT_STOCK("1004", "库存不足，下单、查询可作失败处理"),
    ORDER_STATUS_ERROR("1005", "订单状态有误，下单时可作失败处理，查询订单时不能作失败处理"),
    ACCOUNT_FILE_NOT_GENERATED("1006", "对帐文件未生成，下单、查询可作失败处理"),
    MOBILE_SEGMENT_NOT_FOUND("1007", "未找到手机号段，话费下单如果在我司库里没有号段，返回此错误代码，下单、查询可作失败处理"),
    BLACKLIST_USER("1008", "黑名单用户，下单失败，下单、查询可作失败处理"),
    ORDER_FAILED("1009", "下单失败，下单、查询可作失败处理"),
    PROVINCE_MAINTENANCE("1010", "运营商省份维护，下单失败"),
    NATIONAL_MAINTENANCE("1011", "运营商全国维护，下单失败");

    public static ChongDaCodeEnum getByCode(String code) throws BizException {
        for (ChongDaCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }

    private final String code;

    private final String description;

}
