package cn.com.duiba.supplier.channel.service.api.enums.channel;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 自定义继皋通知类型
 */
@Getter
@AllArgsConstructor
public enum JiGaoNotifyTypeEnum {

    CHARGE_CHANGER(1, "充值状态变更"),

    VERIFY(2, "核销"),

    EXPIRED(3, "过期"),
    ;
    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, JiGaoNotifyTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(JiGaoNotifyTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    public static JiGaoNotifyTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
