package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @author yyk
 * @since 2024/6/22
 */
@RequiredArgsConstructor
@Getter
public enum SuXiCodeEnum {

    SUCCESS("000", "成功"),
    ACCOUNT_ERROR("001", "账号错误"),
    MD5_ERROR("002.", "加密错误"),
    TIMESTAMP_ERROR("003", "时间戳错误"),
    PHONE_ERROR("004", "号码错误"),
    PRODUCT_ERROR("005", "产品错误"),
    PRODUCT_TYPE_ERROR("006", "产品类型错误"),
    ORDER_REPAET("007", "订单号重复(异常处理，需要人工核实)"),
    BALANCE_ERROR("008", "余额不足"),
    DATA_ERROR("009", "数据异常(异常处理，需要人工核实)"),
    SYSTEM_ERROR("010", "系统异常(异常处理，需要人工核实)"),
    ORDER_NOT_FOUND("011", "订单不存在，请人工核实"),
    ;
    public static SuXiCodeEnum getByCode(String code) throws BizException {
        for (SuXiCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }

    private final String code;

    private final String description;

}
