package cn.com.duiba.supplier.channel.service.api.remoteservice.bawangchaji;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.bawangchaji.CancelBaWangChaJiReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.bawangchaji.CancelJiGaoBaWangChaJiReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.bawangchaji.JiGaoBaWangChaJiReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;

/**
 * 玉镜-霸王茶姬
 */
@AdvancedFeignClient
public interface RemoteJiGaoBaWangChaJiService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<JiGaoBaWangChaJiReq> request);

    /**
     * 优惠券作废
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp cancelOrder(CancelBaWangChaJiReq request);


    /**
     * mock核销数据
     * @param request
     */
    void mockVerification(CancelJiGaoBaWangChaJiReq request);
}
