package cn.com.duiba.supplier.channel.service.api.remoteservice.alipay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;

/**
 * @author: LuHui
 * @date: 2024/3/29 17:03
 * @description:
 */
@AdvancedFeignClient
public interface RemoteAlipayBillService {

    /**
     * 查询活动账单下载URL
     *
     * @param appId      支付宝应用ID
     * @param activityId 银行活动ID
     * @return 账单下载地址
     */
    String getBillDownloadUrl(String appId, String activityId);

    /**
     * 获取周期账单下载申请号
     *
     * @param appId      支付宝应用ID
     * @param startTime  账单开始时间
     * @param endTime    账单结束时间
     * @return 账单申请号
     */
    String getDailyBillApplicationId(String appId, Date startTime, Date endTime);

    /**
     * 获取周期账单下载URL
     *
     * @param appId      支付宝应用ID
     * @param applicationId  账单申请号
     * @return 周期账单下载地址
     */
    String getDailyBillDownloadUrl(String appId, String applicationId);
}
