package cn.com.duiba.supplier.channel.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.ExecuteApprovalTaskRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.GetApprovalDetailRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.GetApprovalFileRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.GetApprovalProcessForecastRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.GetApprovalSchemaRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.StartApprovalProcessRequest;
import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.ExecuteApprovalTaskResponse;
import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.GetApprovalDetailResponse;
import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.GetApprovalProcessForecastResponse;
import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.GetApprovalSchemaResponse;
import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.StartApprovalProcessResponse;

/**
 * 钉钉审批流表
 * @author kjj mybatis generator 
 * @date 2024-10-19
 */
@AdvancedFeignClient
public interface RemoteDingTalkApprovalProcessService {

    /**
     * 发起审批
     *
     * @param request 请求参数
     * @return 审批实例id
     */
    StartApprovalProcessResponse startApprovalProcess(StartApprovalProcessRequest request);

    /**
     * 获取单个审批详情
     *
     * @param request 请求参数
     * @return 响应结果
     */
    GetApprovalDetailResponse getApprovalDetail(GetApprovalDetailRequest request);

    /**
     * 获取审批附件
     *
     * @param request 请求参数
     * @return 文件oss地址 长期有效
     */
    String getApprovalFile(GetApprovalFileRequest request);

    /**
     * 获取审批单流程中的节点信息
     * @param request 请求参数
     * @return 响应结果
     */
    GetApprovalProcessForecastResponse getApprovalProcessForecast(GetApprovalProcessForecastRequest request);

    /**
     * 获取审批表单
     *
     * @param request 请求参数
     * @return 响应结果 json字符串
     */
    GetApprovalSchemaResponse getApprovalSchema(GetApprovalSchemaRequest request);

    /**
     * 同意或拒绝审批任务
     *
     * @param request 请求参数
     * @return 执行审批操作返回参数
     */
    ExecuteApprovalTaskResponse executeApprovalTask(ExecuteApprovalTaskRequest request);
}