package cn.com.duiba.supplier.channel.service.api.dto.response.kuaidi100;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * auto num response
 *
 * @author wangguanhua
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class Kuaidi100AutoNumResp extends Kuaidi100BaseResp implements Serializable {

    private static final long serialVersionUID = -2141818642312870711L;

    private List<ExpressCompanyInfo> expressCompanyInfoList;

    /**
     * logistics company info
     *
     * @author wangguanhua
     */
    @Data
    public static class ExpressCompanyInfo implements Serializable {

        private static final long serialVersionUID = 401590409576630834L;

        /**
         * 单号的长度
         */
        private Integer lengthPre;

        /**
         * 快递公司对应的编码
         */
        private String comCode;

        /**
         * 快递公司名称
         */
        private String name;

    }
}
