package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 业务响应码
 * @author lfh
 * @date 2024/1/30 13:46
 */
@Getter
@AllArgsConstructor
public enum FengZhuShouRetCodeEnum {
    PROCESSING("0", "处理中","发货中"),
    SUCCESS("1", "订单发货成功","交易成功"),
    FAIL("9", "订单发货失败","交易失败"),
    GOODS_NOT_EXIST("2000", "单品不存在或已下架","交易失败"),
    ORDER_NOT_EXIST("3000", "订单不存在","交易失败"),
    ACCOUNT_CANNOT_BUY("3100", "账号无法购买此商品","交易失败"),
    PRICE_NOT_MATCH("3104", "价格不匹配","交易失败"),
    ORDER_GENERATE_FAIL("3999", "订单生成失败","交易失败"),
    ORDER_PAY_FAIL("4001", "扣款失败","交易失败"),
    ORDER_PAY_FAIL_BALANCE_NOT_ENOUGH("4002", "账户余额不足","交易失败"),
    ORDER_PAY_FAIL_SYSTEM_ERROR("9999", "系统内部错误","状态未知"),
    ;
    private final String status;
    private final String illustrate;
    private final String desc;
    
}
