package cn.com.duiba.supplier.channel.service.api.dto.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 通用响应
 * @author lizhi
 * @date 2023/4/10 4:03 PM
 */
@Data
public class BaseResp implements Serializable {

    private static final long serialVersionUID = 2991435633620889367L;

    public static final String SUCCESS_CODE = "0000";
    public static final String FAIL_CODE = "1001";
    public static final String SYSTEM_ERROR_CODE = "9999";
    
    /**
     * 请求是否成功（注意仅代表请求是否成功，不代表最终结果）
     */
    private boolean success;

    /**
     * 错误码，最终结果是否成功 0000 为成功，1001为失败，9999为系统异常
     * 目前只有【取消优惠券】在用
     */
    private String code;

    /**
     * 错误信息，请求失败时有值
     */
    private String errMsg;

    /**
     * 调用第三方的唯一单号，若为null，说明调用第三方失败，且不可重试
     * 不为null的时候，仅代表未确认失败，不代表已经成功了。具体结果以回调结果或查询结果为准
     */
    private String outBizNo;
    
    public <T extends BaseResp> T buildErr(String errMsg) {
        this.setSuccess(false);
        this.setErrMsg(errMsg);
        return (T)this;
    }
    
    public <T extends BaseResp> T buildSuccess(String outBizNo) {
        this.setSuccess(true);
        this.setOutBizNo(outBizNo);
        return (T)this;
    }

    /**
     * 系统异常 请求失败，结果错误，目前只有【取消优惠券】在用
     * @param errMsg 错误信息
     * @return
     * @param <T>
     */
    public <T extends BaseResp> T buildSystemErrAndCode(String errMsg) {
        this.setSuccess(false);
        this.setCode(SYSTEM_ERROR_CODE);
        this.setErrMsg(errMsg);
        return (T)this;
    }

    /**
     * 请求成功，结果错误，目前只有【取消优惠券】在用
     * @param errMsg
     * @return
     * @param <T>
     */
    public <T extends BaseResp> T buildErrAndCode(String errMsg) {
        this.setSuccess(true);
        this.setCode(FAIL_CODE);
        this.setErrMsg(errMsg);
        return (T)this;
    }

    /**
     * 请求成功，结果正确，目前只有【取消优惠券】在用
     * @param outBizNo
     * @return
     * @param <T>
     */
    public <T extends BaseResp> T buildSuccessAndCode(String outBizNo) {
        this.setSuccess(true);
        this.setCode(SUCCESS_CODE);
        this.setOutBizNo(outBizNo);
        return (T)this;
    }
}
