package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * DingXinCodeEnum
 *
 * @author fmk
 * @since 2024/2/21
 */
@RequiredArgsConstructor
@Getter
public enum DingXinCodeEnum {

    REQUEST_SUCCESS(7000, "请求通过"),
    INVALID_PARAMETERS(7001, "请求参数错误，请检查参数名和数据格式"),
    REQUEST_TIMEOUT(7002, "请求超时，请检查timestamp是否是当前请求时间"),
    MERCHANT_ACCOUNT_NOT_FOUND(7003, "商户账号不存在，请检查app_id是否正确"),
    MERCHANT_ACCOUNT_SUSPENDED_OR_DISABLED(7004, "商户账号状态暂停或禁用，请联系橙券客服处理"),
    SIGNATURE_ERROR(7005, "签名错误，请按照ASCII码从小到大排序拼接参数名参数值尾部加密钥后MD5加密，例如：MD5(a=value1&b=value2…&key=您的密钥)"),
    INVALID_IP(7006, "请求IP有误，请检查请求IP是否正确"),
    MOBILE_NUMBER_LOCATION_NOT_FOUND(7007, "查询不到手机卡号归属地，请检查手机号是否填写正确"),
    PRODUCT_NOT_FOUND(7008, "查询不到产品，请联系橙券客服处理"),
    PRODUCT_OFFLINE(7009, "产品已下架，请联系橙券客服处理"),
    MERCHANT_PRICE_NOT_FOUND(7010, "查询不到商户密价，请联系橙券客服处理"),
    MERCHANT_PRICE_SUSPENDED(7011, "商户密价状态暂停，请联系橙券客服处理"),
    DUPLICATE_ORDER(7012, "请求订单号已存在，请联系橙券客服处理"),
    ORDER_STORAGE_EXCEPTION(7013, "请求订单入库异常，请稍后重试或联系橙券客服处理"),
    INSUFFICIENT_BALANCE(7014, "商户账号余额不足，请进行充值"),
    MERCHANT_DEDUCTION_EXCEPTION(7015, "商户扣款异常，请稍后重试或联系橙券客服处理"),
    ORDER_NOT_FOUND(7016, "请求订单不存在，请检查订单号是否正确"),
    INCORRECT_FUEL_CARD_NUMBER(7017, "加油卡卡号不正确，请使用真实的中石化/中石油加油卡号"),
    INSUFFICIENT_PRODUCT_STOCK(7019, "产品库存不足，请联系橙券客服处理"),
    SYSTEM_EXCEPTION(7777, "系统异常，请联系橙券客服处理(调用充值类业务时，请务必联系客服或通过订单查询接口检测订单，避免造成损失)");

    private final int code;

    private final String description;

    public static DingXinCodeEnum convert(Integer code) throws BizException {
        for (DingXinCodeEnum codeEnum : values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        throw new BizException("状态码错误,code=" + code);
    }

}
