package cn.com.duiba.supplier.channel.service.api.dto.response;

import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelOrderStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 明细发放结果
 * @author lizhi
 * @date 2023/4/24 1:48 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseDetailResultResp extends BaseResp {
    
    private static final long serialVersionUID = 2323882509274354628L;

    /**
     * 业务类型
     * {@link BizTypeEnum}
     */
    private Integer bizType;

    /**
     * 业务方唯一单号
     */
    private String bizNo;

    /**
     * 调用第三方的唯一单号
     */
    private String outDetailNo;

    /**
     * 状态, 1-初始化，2-处理中，3-内部校验不通过，4-调用第三方发生异常，5-第三方中间状态，6-第三方失败-不能自动重试，7-第三方失败-可自动重试，8-第三方成功，9-内部发生异常
     * {@link ChannelOrderStatusEnum}
     */
    private Integer orderStatus;

    /**
     * 最新的第三方响应的流水号
     */
    private String respSerialNo;

    /**
     * 最新失败原因
     */
    private String errorMsg;
    
}
