package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author nongfu
 * @Date 2025/1/13 11:23
 */
@Getter
@AllArgsConstructor
public enum CreativeAwerenessStatusEnum {

    UNTREATED("untreated","未处理"),
    PROCESSING("processing","处理中"),
    FAILED("failed","失败"),
    SUCCESS("success","已完成")
    ;


    private final  String status;

    private final String desc;

    public static CreativeAwerenessStatusEnum getByStatus(String status) {
        for (CreativeAwerenessStatusEnum value : values()) {
            if (value.getStatus().equals(status)) {
                return value;
            }
        }
        return PROCESSING;
    }
}
