package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum ShenBianYunSigningTypeEnum {

    NO_SIGNING(0, "未签约"),
    SIGNING_SUCCESS(1, "已签约"),
    NO_SIGNING_INFO(2, "未检索到个体工商业者信息"),
    SIGNING_PROPRESS(3, "签约中"),
    SIGNING_FAIL(4, "签约失败"),
    ;

    private static final Map<Integer, ShenBianYunSigningTypeEnum> codeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(ShenBianYunSigningTypeEnum::getCode, Function.identity(), (v1, v2) -> v1));

    public static ShenBianYunSigningTypeEnum getByCode(Integer code) {
        return codeEnumMap.get(code);
    }

    private final Integer code;

    private final String desc;
}
