package cn.com.duiba.supplier.channel.service.api.enums.threadpool;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 *
 *
 * @author zzy
 * @create 2024/12/04 18:05
 **/
@Getter
@AllArgsConstructor
public enum ChannelThreadPoolTypeEnum {
    THREAD_NORMAL(1, "普通线程池"),
    THREAD_URGENCY(2, "紧急线程池，适用于同步请求"),
    ;
    private final int type;
    private final String desc;

    public static ChannelThreadPoolTypeEnum getByType(Integer type) {
        for (ChannelThreadPoolTypeEnum value : values()) {
            if (Objects.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }
}
