package cn.com.duiba.supplier.channel.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.conf.AlipayMchInfoDto;
import cn.com.duiba.supplier.channel.service.api.param.conf.AlipayMchInfoSearchParam;
import java.util.List;

/**
 * 支付宝商户信息表
 * @author kjj mybatis generator 
 * @date 2025-01-14
 */
@AdvancedFeignClient
public interface RemoteAlipayMchInfoService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝商户信息集合
     */
    List<AlipayMchInfoDto> selectPage(AlipayMchInfoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayMchInfoSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝商户信息
     */
    AlipayMchInfoDto selectById(Long id);

    /**
     * 根据商户号查询
     * @param mchCode
     * @return
     */
    AlipayMchInfoDto selectByMchCode(String mchCode);

    /**
     * 查询总余额
     * @param param
     * @return
     */
    long selectSumBalance(AlipayMchInfoSearchParam param);

    /**
     * 新增
     * @param dto 支付宝商户信息
     * @return 执行结果
     */
    int insert(AlipayMchInfoDto dto);

    /**
     * 更新
     * @param dto 支付宝商户信息
     * @return 影响行数
     */
    int update(AlipayMchInfoDto dto);

    /**
     * 更新警告开关
     * @param dto 更新参数
     * @return 更新结果
     */
    int updateWarnInfo(AlipayMchInfoDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新余额
     */
    int updateBalance(AlipayMchInfoDto dto);
}