package cn.com.duiba.supplier.channel.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2024/10/22 19:37
 **/
@AdvancedFeignClient
public interface RemoteDingTalkDeptService {

    /**
     * 根据部门id集合查询部门名称
     *
     * @param appKey appKey
     * @param deptIds 部门id集合
     * @return key: deptId, value: deptName
     */
    Map<Long, String> getDeptNameMapByDeptIdsAndAppKey(String appKey, List<Long> deptIds);

    /**
     * 根据部门id集合批量新增或更新部门信息
     *
     * @param appKey appKey
     * @param deptIds 部门id集合
     * @return 执行结果
     */
    boolean batchSaveOrUpdate(List<Long> deptIds, String appKey);

    /**
     * 根据部门id集合批量删除部门信息
     * @param deptIds 部门id集合
     * @param appKey appKey
     * @return 执行结果
     */
    boolean batchDelete(List<Long> deptIds, String appKey);
}
