package cn.com.duiba.supplier.channel.service.api.dto.request.douyin;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/** 抖音支付通知请求参数 */
@Data
public class DouYinCallBackReq {

  private final String serialNumber;
  private final String signature;
  private final String message;
  private final String body;
  private final String signType;

  private DouYinCallBackReq(
      String serialNumber, String signature, String message, String body, String signType) {
    this.serialNumber = serialNumber;
    this.signature = signature;
    this.message = message;
    this.body = body;
    if (signType == null || signType.isEmpty()) {
      this.signType = "RSA";
    } else {
      this.signType = signType;
    }
  }
  public static class Builder {

    String signType;
    private String serialNumber;
    private String timestamp;
    private String nonce;
    private String signature;
    private String body;

    public Builder serialNumber(String serialNumber) {
      this.serialNumber = serialNumber;
      return this;
    }

    public Builder timestamp(String timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    public Builder nonce(String nonce) {
      this.nonce = nonce;
      return this;
    }

    public Builder signature(String signature) {
      this.signature = signature;
      return this;
    }

    public Builder signType(String signType) {
      this.signType = signType;
      return this;
    }

    public Builder body(String body) {
      this.body = body;
      return this;
    }

    public DouYinCallBackReq build() {
      String message = timestamp + "\n" + nonce + "\n" + body + "\n";
      return new DouYinCallBackReq(serialNumber, signature, message, body, signType);
    }
  }
}
