package cn.com.duiba.supplier.channel.service.api.remoteservice.douyin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.douyin.DouYinCallBackReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.douyin.DouYinCouponStatusReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.douyin.DouYinReceiveCouponReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinCallBackResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinCouponInfoResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinCouponStatusResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinReceiveCouponResp;

/**
 * 抖音支付券
 */
@AdvancedFeignClient
public interface RemoteDouYinCouponService {

    /**
     * 查询抖音支付券信息
     *
     * @param activityId 活动 id
     * @param mchId      商户 id
     * @return 抖音支付券信息
     */
    DouYinCouponInfoResp getDouYinCouponInfo(String activityId, String mchId);

    /**
     * 领取抖音支付券
     *
     * @param couponReq
     * @return 领券结果
     */
    DouYinReceiveCouponResp receiveCoupon(DouYinReceiveCouponReq couponReq);

    /**
     * 查询券状态
     *
     * @param req 查询券状态请求
     * @return 券状态
     */
    DouYinCouponStatusResp queryCpuponStatus(DouYinCouponStatusReq req);

    /**
     * 抖音回调
     *
     * @param req 回调请求
     * @return 回调结果
     */
    DouYinCallBackResp callback(DouYinCallBackReq req);
}
