package cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 微信代金劵条件查询批次列表
 * @author lizhi
 * @date 2023/5/17 4:54 PM
 */
@Data
public class WxFavorStocksListReq implements Serializable {
    
    private static final long serialVersionUID = 841008421510428339L;

    /**
     * 商户ID
     */
    @NotBlank(message = "mchId must not be null")
    @Size(max = 20, message = "mchId不能超过32")
    private String mchId;
    
    /**
     * 分页页码
     * 说明：页码从0开始，默认第0页。
     */
    @NotNull(message = "offset must not be null")
    private Integer offset;

    /**
     * 分页大小
     * 说明：分页大小，最大10。
     */
    @NotNull(message = "limit must not be null")
    @Max(value = 10, message = "limit最大10")
    private Integer limit;

    /**
     * 创建批次的商户号
     */
    @NotBlank(message = "stockCreatorMchId must not be null")
    @Size(max = 20, message = "stockCreatorMchId不能超过32")
    private String stockCreatorMchId;

    /**
     * 起始时间
     * 说明：起始创建时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 校验规则：get请求，参数在 url中，需要进行 url 编码传递
     * 示例值：2015-05-20T13:29:35+08:00
     * 选填，string(64)
     */
    private String createStartTime;

    /**
     * 终止时间	
     * 说明：终止创建时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 校验规则：get请求，参数在 url中，需要进行 url 编码传递
     * 示例值：2015-05-20T13:29:35+08:00
     * 选填，string(64)
     */
    private String createEndTime;

    /**
     * 批次状态		
     * 说明：批次状态，枚举值：
     * unactivated：未激活
     * audit：审核中
     * running：运行中
     * stoped：已停止
     * paused：暂停发放
     * 示例值：paused
     * 选填，string(16)
     */
    private String status;
}
