package cn.com.duiba.supplier.channel.service.api.dto.request.wx.redpacket;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 继皋直充-微信红包
 *
 * @author wangguanhua
 */
@Data
public class JiGaoWxRedPacketReq implements Serializable {

    private static final long serialVersionUID = -1323854709204807445L;

    /**
     * 商户编号
     * 必填
     */
    private String channelId;

    /**
     * 用户微信openId
     * 最大32位
     * 必填
     */
    @NotBlank(message = "openId不能为空")
    private String openId;

    /**
     * 金额，单位元
     */
    @NotBlank(message = "金额不能为空")
    private String facePrice;

    /**
     * 微信公众账号ID
     * 必填
     */
    @NotBlank(message = "appId不能为空")
    private String appId;

    /**
     * 微信的红包备注
     * 必填
     */
    @NotBlank(message = "红包备注不能为空")
    private String remark;

    /**
     * 商户名称
     * ● 商品为微信红包时，必填
     */
    @NotBlank(message = "商户名称不能为空")
    private String redpackBusiness;

    /**
     * 红包祝福语
     * ● 商品为微信红包时，必填
     */
    @NotBlank(message = "红包祝福语不能为空")
    private String redpackBlessings;

    /**
     * 商品编码，由继皋提供清单
     * 必填
     */
    private String productId;

    /**
     * 是否有发票：0无票、1专票、2零票，默认为1
     * 必填
     */
    private String voiceFlag;
}
