package cn.com.duiba.supplier.channel.service.api.dto.response.carser;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CarAfterQueryMchResp implements Serializable {

    private static final long serialVersionUID = -1L;

    private Long total;

    private Long pageSize;

    private Long pageIndex;

    private List<StoreDto> stores;

    @Data
    public static class StoreDto implements Serializable {

        private static final long serialVersionUID = -1L;

        /**
         * 网点名称
         */
        private String storeName;

        /**
         * 网点编码
         */
        private String storeCode;

        /**
         * 店铺详细地址
         */
        private String storeAddress;

        /**
         * 服务类型编码，多个用逗号分隔
         */
        private String subServiceTypes;

        /**
         * 联系电话
         */
        private String contactMobile;

        /**
         * 店铺营业时间,
         */
        private String businessTime;

        /**
         * 店铺图片
         */
        private String storeImage;

        /**
         * 联系人
         */
        private String contactName;

        /**
         * 经纬度
         */
        private String longLatitude;

        /**
         * 省份编码
         */
        private String provinceCode;

        /**
         * 省份名称
         */
        private String provinceName;

        /**
         * 城市编码
         */
        private String cityCode;

        /**
         * 市名称
         */
        private String cityName;

        /**
         * 区县名称
         */
        private String countyName;

        /**
         * 区县编码
         */
        private String countyCode;

        /**
         * 服务订单数量
         */
        private String orderCount;

    }

}
