package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * DianDianCodeEnum
 *
 * @author fmk
 * @since 2024/2/18
 */
@Getter
@RequiredArgsConstructor
public enum DianDianCodeEnum {

    MISSING_REQUIRED_PARAMETER("0101", "缺少必需参数"),
    SIGNATURE_FAILURE("0102", "签名失败"),
    INVALID_PARAMETER_FORMAT_OR_VALUE("0103", "参数格式错误或取值非法"),
    ORDER_NOT_FOUND("0104", "找不到对应的订单"),
    IP_NOT_IN_WHITE_LIST("0105", "IP不在白名单"),
    MERCHANT_NOT_EXIST("0106", "商户号不存在"),
    MERCHANT_INTERFACE_CLOSED("0107", "商户接口被关闭"),
    DUPLICATE_ORDER("0301", "订单重复"),
    INVALID_PURCHASE_QUANTITY("0302", "购买数量非法"),
    INSUFFICIENT_PRODUCT_STOCK("0303", "商品库存不足"),
    PRODUCT_UNDER_MAINTENANCE("0304", "商品维护中"),
    PRODUCT_NOT_FOUND("0305", "找不到对应的商品"),
    INVALID_RECHARGE_ACCOUNT_FORMAT("0306", "充值帐户格式错误"),
    OPERATOR_ROUTINE_MAINTENANCE("0501", "运营商例行维护"),
    INVALID_RECHARGE_ACCOUNT("0502", "充值帐户错误或不存在"),
    RECHARGE_FAILED("0503", "充值失败"),
    INSUFFICIENT_ACCOUNT_BALANCE("0601", "帐号余额不足"),
    ILLEGAL_ORDER_STATUS_TRANSITION("0701", "非法的订单状态转换"),
    ORDER_CANCELLED("0901", "订单取消"),
    UNKNOWN_ERROR("9999", "未知错误");

    private final String code;

    private final String message;

    public static DianDianCodeEnum convert(String code) throws BizException {
        for (DianDianCodeEnum codeEnum : values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        throw new BizException("状态码错误,code=" + code);
    }
}
