package cn.com.duiba.supplier.channel.service.api.dto.request.kuaidi100;

import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * kuaidi100 subscribe req
 *
 * @author wangguanhua
 */
@Data
public class Kuaidi100SubscribeReq implements Serializable {

    private static final long serialVersionUID = 7562617010895891215L;

    /**
     * 业务方类型
     *
     * @see BizTypeEnum#getType()
     */
    private Integer bizType;

    /**
     * 业务方唯一订单号
     */
    private String bizNo;

    /**
     * 物流单号
     */
    private String expressNo;

    /**
     * 物流公司
     */
    private String expressCompany;

    /**
     * 收货人手机号
     */
    private String phone;

    /**
     * mq topic
     */
    private String mqTopic;

    /**
     * mq tag
     */
    private String mqTag;
}
