package cn.com.duiba.supplier.channel.service.api.dto.response.alipay;

import lombok.Data;

import java.io.Serializable;

/**
 * 数字分行用户账号查询接口
 * @author lizhi
 * @date 2024/1/15 17:55
 */
@Data
public class AlipayDtBankCustAccountInfoResp implements Serializable {
    
    private static final long serialVersionUID = 1933261163952808325L;

    /**
     * ● 若传入logon_id，则查询用户名下所有已实名的、作为登录账号的支付宝账号 
     * ● 若传入phone_id，则查询用户名下所有已实名的，以手机号作为登录账号以及以绑定了该手机号的支付宝账号
     * 必选
     * 最大长度200
     */
    private String accountNo;

    /**
     * 用户支付宝账号userId对应的openid
     * 必选
     * 最大长度200
     */
    private String openId;
}
