package cn.com.duiba.supplier.channel.service.api.dto.response.douyin;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 抖音支付券详情
 */
@Data
public class DouYinCouponInfoResp implements Serializable {


    private static final long serialVersionUID = 6151407182569009078L;
    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 活动ID
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动有效期开始时间
     */
    private Date activityBeginTime;

    /**
     * 活动有效期结束时间
     */
    private Date activityEndTime;

    /**
     * 每个账号每日可领
     */
    private Integer dailyLimit;

    /**
     * 每个账号活动周期内可领
     */
    private Integer validityPeriodLimit;

    /**
     * ====================券批次信息=================
     */
    /**
     * 券批次 id
     */
    private String stockId;

    /**
     * 券批次状态
     */
    private String status;

    /**
     * 活动预算
     */
    private Integer budget;

    /**
     * 出资方式
     */
    private String fundType;

    /**
     * 银行卡渠道
     */
    private String bankChannel;

    /**
     * 卡bin
     */
    private String limitedBins;

    /**
     * 券类型
     */
    private String stockType;

    /**
     * 优惠金额
     */
    private Integer reduceAmount;

    /**
     * 使用门槛金额
     */
    private Integer reachedAmount;

    /**
     * 总发放张数
     */
    private Integer totalNum;

    /**
     * 券使用有效期类型
     */
    private String validType;

    /**
     * 相对有效期配置类型
     */
    private String relativeStartType;

    /**
     * 有效期生效天数
     */
    private Integer relativeStartDays;

    /**
     * 相对有效期生效时长
     */
    private Integer validRelativeSeconds;

    /**
     * 是否支持退款退券
     */
    private String isRefundCoupon;

    /**
     * 券可用开始时间
     */
    private Date validBeginTime;

    /**
     * 券可用结束时间
     */
    private Date validEndTime;

    /**
     * 券简要使用说明
     */
    private String shortDesc;

    /**
     * 券详细使用说明
     */
    private String description;

    /**
     * 背景图
     */
    private String bgUrl;

    /**
     * 券LOGO
     */
    private String logoUrl;

    /**
     * 跳转链接
     */
    private String jumpUrl;
}
