package cn.com.duiba.supplier.channel.service.api.dto.response.express.mq;

import cn.com.duiba.supplier.channel.service.api.enums.express.ExpressMqCallbackTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * express track info dto
 *
 * @author wangguanhua
 */
@Data
public class ExpressMqCallbackDto implements Serializable {

    private static final long serialVersionUID = 4967765726071455804L;

    /**
     * 业务方类型
     *
     * @see BizTypeEnum#getType()
     */
    private Integer bizType;

    /**
     * 业务方唯一订单号
     */
    private String bizNo;

    /**
     * 物流单号
     */
    private String expressNo;

    /**
     * 物流公司
     */
    private String expressCompany;

    /**
     * callback type
     *
     * @see ExpressMqCallbackTypeEnum#getType()
     */
    private Integer callbackType;

    /**
     * callback data
     *
     * @see ExpressSubscribeResult {@link ExpressMqCallbackTypeEnum#SUBSCRIBE_RESULT#getCallbackType()}
     * @see ExpressStatusResult {@link ExpressMqCallbackTypeEnum#EXPRESS_STATUS_RESULT#getCallbackType()}
     */
    private String callbackData;

}
