package cn.com.duiba.supplier.channel.service.api.enums.channel;

import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Cloud360CodeEnum
 *
 * @author fmk
 * @since 2024/1/19
 */
@RequiredArgsConstructor
@Getter
public enum Cloud360CodeEnum {

    SUCCESS(0, "成功"),
    INVALID_CLIENT(102, "client_id 或者 client_secret 错误"),
    UNSUPPORTED_GRANT_TYPE(109, "grant_type 错误"),
    INVALID_TOKEN(111, "header 里 Access-Token 过期"),
    EXPIRED_TOKEN(112, "header 里 Access-Token 过期"),
    SIGN_INVALID(312, "sign错误"),
    QID_AND_ACCESS_TOKEN_NOT_MATCH(315, "手机号和 header 里 Access-Token 不匹配"),
    HEADER_ERROR(701, "method错误"),
    TOO_MUCH_ORDER_IDS(801, "订单数量超出限制"),
    INVALID_MOBILE(802, "手机号格式错误"),
    PERMISSION_DENIED_TO_ACCESS_THIS_API(803, "权限不足,不支持该接口访问"),
    INVALID_BUSINESS_ORDER_NO_LENGTH(804, "business_order_no长度超出限制"),
    ORDER_NO_REPEAT(66001, "订单号重复"),
    CONFLICT(66003, "与已有会员权益冲突"),
    HAS_VIP(66004, "指定时间内已经开通过会员"),
    PACKAGE_TYPE_ERROR(66005, "package_type类型错误");

    private static final Map<Integer, Cloud360CodeEnum> codeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(Cloud360CodeEnum::getCode, Function.identity(), (v1,v2) -> v1));

    public static Cloud360CodeEnum getByCode(Integer code) {
        return codeEnumMap.get(code);
    }

    private final Integer code;

    private final String desc;

}
