package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum DouYinPayCouponCodeEnum {

    SUCCESS(200, "SUCCESS", "接口调用成功"),

    //400
    PARAM_ERROR(400, "参数异常", "交易失败"),
    STOCK_STATUS_ERROR(400, "券批次状态异常", "交易失败"),
    USER_NOT_EXISTS(400, "用户id不合法", "交易失败"),
    ACTIVITY_NOT_EXISTS(400, "活动id不合法", "交易失败"),
    STOCK_NOT_ENOUGH(400, "券批次库存不足", "交易失败"),
    USER_STOCK_LIMIT(400, "用户发券达到限额", "交易失败"),
    COUPON_FAIL_ERROR(400, "发券失败", "交易失败"),
    COUPON_NOT_EXISTS(400, "券不存在", "交易失败"),

    //403
    RISK_CONTROL_INTERCEPTION(403, "风控拦截", "交易失败"),
    USER_NO_AUTH(403, "用户无操作权限", "交易失败"),
    MERCHANT_NO_AUTH(403, "商户无活动发券权限", "交易失败"),

    //500
    SYSTEM_ERROR(500, "SYSTEM_ERROR", "状态未知"),

    //自定义
    SIGN_VERIFICATION_FAIL(999, "验签失败", "交易中"),

    SERIALIZATION_FAILED(1000, "序列化失败", "交易中"),

    SIGN(1001, "加签失败", "交易失败")

    ;

    /**
     * 状态码
     */
    private final Integer statusCode;

    /**
     * 错误码
     */
    private final String errorMsg;

    /**
     * 描述
     */
    private final String desc;
}
