package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/2/19 17:29
 * @description:
 */
@Getter
@AllArgsConstructor
public enum NaiXueCouponGiveCodeEnum {
    /**
     * 0-未转赠 1-赠送中 2-已转赠
     */
    NOT_GIVE(0, "未转赠"),
    GIVING(1, "赠送中"),
    GIVE(2, "已转赠"),
    ;


    private static final Map<Integer, NaiXueCouponGiveCodeEnum> codeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(NaiXueCouponGiveCodeEnum::getCode, Function.identity(), (v1, v2) -> v1));

    public static NaiXueCouponGiveCodeEnum getByCode(Integer code) {
        return codeEnumMap.get(code);
    }

    private final Integer code;

    private final String desc;
}
