package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * YiPaiOrderStatusEnum
 *
 * @author fmk
 * @since 2024/3/5
 */
@RequiredArgsConstructor
@Getter
public enum YiPaiStatusEnum {

    SUCCESS("01", "成功"),
    FAILURE("02", "失败"),
    PROCESSING("03", "处理中"),
    ORDER_NOT_FOUND("04", "订单不存在"),
    UNKNOWN_ERROR("05", "未知错误"),
    SIGNATURE_ERROR("06", "签名错误"),
    INVALID_PARAMETER("07", "参数有误");

    private final String code;
    private final String description;

    public static YiPaiStatusEnum convert(String code) throws BizException {
        for (YiPaiStatusEnum codeEnum : values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        throw new BizException("状态码错误,code=" + code);
    }
}
