package cn.com.duiba.supplier.channel.service.api.remoteservice.douyin;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.douyin.DouYinCallBackReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.douyin.DouYinCouponStatusReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.douyin.DouYinReceiveCouponReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.telaidian.TeLaiDianCouponZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinCouponInfoResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinCouponStatusResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinPayNotifyResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.douyin.DouYinReceiveCouponResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
@AdvancedFeignClient
public interface RemoteDouYinPayCouponService {


    /**
     * 查询抖音支付券信息
     *
     * @param activityId 活动 id
     * @param mchId      商户 id
     * @return 抖音支付券信息
     */
    DouYinCouponInfoResp getDouYinCouponInfo(String activityId, String mchId) throws BizException;

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<DouYinReceiveCouponReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<DouYinReceiveCouponResp> distributeResult(Integer bizType, String bizNo);

    /**
     * 第三方通知结果
     *
     * @param body 通知消息体
     * @return 是否处理成功
     */
    boolean notify(String body);

    /**
     *  回调
     * @param req 请求
     * @return 回调结果
     */
    DouYinPayNotifyResp notifyValidateAndDecryptResource(DouYinCallBackReq req);
}
