package cn.com.duiba.supplier.channel.service.api.dto.response.order;

import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelOrderStatusEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.NotifyTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: LuHui
 * @date: 2024/2/22 18:20
 * @description:
 */
@Data
public class ChannelOrderDto implements Serializable {
    private static final long serialVersionUID = 2867983371351130337L;


    /**
     * 自增主键
     */
    private Long id;

    /**
     * 渠道
     * {@link ChannelTypeEnum}
     */
    private Integer channelType;

    /**
     * 业务类型
     * {@link BizTypeEnum}
     */
    private Integer bizType;

    /**
     * 业务方唯一单号
     */
    private String bizNo;

    /**
     * 最新的调用第三方的唯一单号，生成规则：结合biz_type+biz_no+retry_count+第三方要求
     */
    private String outBizNo;

    /**
     * 用于搜索日志的编码，无其他用处，可为空
     * （目前积分商城的技术支持，会通过积分商城短链url上的code码搜索日志查看发放结果，其他业务建议用单号搜索日志）
     */
    private String logCode;

    /**
     * 通知类型
     * {@link NotifyTypeEnum}
     */
    private Integer notifyType;

    /**
     * 回调结果的mq的topic
     */
    private String mqTopic;

    /**
     * 回调结果的mq的tag
     */
    private String mqTag;

    /**
     * 状态, 1-初始化，2-处理中，3-内部校验不通过，4-调用第三方发生异常，5-第三方中间状态，6-第三方失败，7-第三方成功，8-内部发生异常
     * {@link ChannelOrderStatusEnum}
     */
    private Integer orderStatus;

    /**
     * 已重试次数
     */
    private Integer retryCount;

    /**
     * 最新的订单记录号
     */
    private String recordNo;

    /**
     * 最新的第三方响应的流水号
     */
    private String respSerialNo;

    /**
     * 最新的失败原因
     */
    private String errorMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 兑吧主体
     * @see cn.com.duiba.supplier.channel.service.api.enums.order.SubjectEnum
     */
    private Integer duibaSubject;
}
