package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * @author fmk
 * @since 2024/2/26
 */
@RequiredArgsConstructor
@Getter
public enum FeiHanCodeEnum {

    SUCCESS(1, "成功"),
    FAIL(0, "失败(只供查询使用)"),
    MERCHANT_NAME_ERROR(1001, "商户名验证错误"),
    MERCHANT_IP_ERROR(1002, "商户IP验证错误"),
    MD5_VALIDATION_ERROR(1003, "MD5串验证错误"),
    ITEM_UNAVAILABLE(1004, "此商品暂不可用"),
    QUANTITY_EXCEEDS_SYSTEM_REQUIREMENTS(1005, "购买的商品数量超出系统要求"),
    RECHARGE_AMOUNT_EXCEEDS_SYSTEM_LIMIT(1006, "充值金额超出系统限制"),
    INSUFFICIENT_ACCOUNT_BALANCE(1007, "账户金额不足"),
    MISSING_REQUIRED_PARAMETERS(1008, "缺少必需参数"),
    UNKNOWN_ERROR(9999, "未知错误(不能作失败处理，需要人工核实)"),
    INCORRECT_PHONE_NUMBER(319, "充值的手机号不正确"),
    UNSUPPORTED_PHONE_NUMBER(321, "暂时不支持此类手机号的充值"),
    ORDER_GENERATION_FAILURE(331, "订单生成失败"),
    INVALID_PARAMETER_FORMAT(9998, "参数格式错误"),
    PAYMENT_EXCEPTION(4001, "支付异常");

    private final Integer code;
    private final String message;

    public static FeiHanCodeEnum convert(Integer code) throws BizException {
        for (FeiHanCodeEnum codeEnum : values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        throw new BizException("状态码错误,code=" + code);
    }

}
