package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/2/19 16:58
 * @description:
 */
@Getter
@AllArgsConstructor
public enum NaiXueCodeEnum {

    SUCCESS(0, "成功"),
    PARAM_ERROR(250400, "参数错误"),
    FAIL(250600, "操作失败"),
    SYSTEM_ERROR(250500, "系统错误"),
    SIGN_ERROR(250401, "签名错误"),
    ACTIVITY_TOTAL_LIMIT(210710, "活动获得总量已达上限"),
    ACTIVITY_REACH_LIMIT(210712, "已领取，请不要重复操作"),
    ACTIVITY_JOIN_LIMIT(210711, "用户参与活动次数已达上限"),
    ACTIVITY_CODE_ERROR(210716, "优惠券不存在"),
    ;

    private static final Map<Integer, NaiXueCodeEnum> codeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(NaiXueCodeEnum::getCode, Function.identity(), (v1, v2) -> v1));

    public static NaiXueCodeEnum getByCode(Integer code) {
        return codeEnumMap.get(code);
    }

    private final Integer code;

    private final String desc;
}
