package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * @author: LuHui
 * @date: 2024/8/8 17:20
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SubjectEnum {

    DUI_BA(1, "兑吧"),
    DUI_A(2, "兑啊"),
    DUI_JIE(3, "兑捷"),
    ;


    private final Integer type;

    private final String desc;

    public static SubjectEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (SubjectEnum subject : SubjectEnum.values()) {
            if (Objects.equals(subject.getType(), type)) {
                return subject;
            }
        }
        return null;
    }


}
