package cn.com.duiba.supplier.channel.service.api.dto.request.rongshu;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 荣数通用请求类
 *
 * @author wangguanhua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RongshuCommonRequest implements Serializable {

    private static final long serialVersionUID = -7307314956263505850L;

    /**
     * 渠道号
     */
    private String orgNo;

    /**
     * 签名参数
     * 请求发送方将数据包计算之后得到的签名，需要请求接收方验签
     */
    private String sign;

    /**
     * 请求参数
     * 请求发送方将Json串加密后得到的字符串，需要请求接收方解密，详见具体接口
     */
    private String data;
} 