package cn.com.duiba.supplier.channel.service.api.remoteservice.car;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.carser.CarEasyChargeReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.carser.CarEasyChargeResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.carser.CarEasyQueryMchResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

import java.util.List;

/**
 * @author lizhi
 * @date 2024/8/6 17:21
 */
@AdvancedFeignClient
public interface RemoteCarEasyCarSerService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<CarEasyChargeReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<CarEasyChargeResp> distributeResult(Integer bizType, String bizNo);

    /**
     * 第三方通知结果
     *
     * @param body 通知消息体
     * @return 是否处理成功
     */
    boolean notify(String body);


    /**
     * 查询汽车服务商户列表
     * @param mchId 商户id
     * @param cityCode 城市编码
     * @param pageNo 页码
     * @param pageSize 每页数量
     * @return
     */
    List<CarEasyQueryMchResp> queryMch(String mchId, String cityCode, Integer pageNo, Integer pageSize) throws BizException;
}
