package cn.com.duiba.supplier.channel.service.api.enums.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付宝转账产品码枚举
 * @author yangyukang
 * @date 2025-01-26
 */
@Getter
@AllArgsConstructor
public enum AlipayTransferProductCodeEnum {
    
    /**
     * 单笔无密转账到支付宝账户
     */
    TRANS_ACCOUNT_NO_PWD("TRANS_ACCOUNT_NO_PWD", "单笔无密转账到支付宝账户"),
    
    /**
     * 收发现金红包
     */
    STD_RED_PACKET("STD_RED_PACKET", "收发现金红包");

    /**
     * 产品码
     */
    private final String code;
    
    /**
     * 描述
     */
    private final String desc;
} 