package cn.com.duiba.supplier.channel.service.api.remoteservice.chabaidaocoupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.chabaidaocoupon.DingXinChaBaiDaoCouponZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.chabaidaocoupon.DingXinChaBaiDaoCouponZcResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * 鼎信茶百道代金券直充远程服务接口
 *
 * @author yangyukang
 * @since 2024/12/25
 */
@AdvancedFeignClient
public interface RemoteDingXinChaBaiDaoCouponZcService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<DingXinChaBaiDaoCouponZcReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *        {@link BizTypeEnum}
     * @param bizNo 业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<DingXinChaBaiDaoCouponZcResp> distributeResult(Integer bizType, String bizNo);
} 