package cn.com.duiba.supplier.channel.service.api.dto.request.carser;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 车妈妈汽车服务入参
 * @author yanggyukagn
 * @date 2024/1/24 1:36 PM
 */
@Data
public class CarMomChargeReq implements Serializable {

    private static final long serialVersionUID = -6768260494229922768L;

    /**
     * 店铺编码
     */
    @NotNull(message = "店铺编码不能为空")
    private String storeCode;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String phone;

    /**
     * 车牌号
     */
    @NotBlank(message = "车牌号不能为空")
    private String carNumber;

    /**
     * 商品信息
     */
    private CarMomGoodsInfoReq carMomGoodsInfoReq;

    /**
     * 接入方编码
     */
    private String partnerCode;

    /**
     * 核销到期时间
     */
    private Date verificationExpireTime;

}
