package cn.com.duiba.supplier.channel.service.api.dto.response.jd;

import lombok.Data;

import java.io.Serializable;

/**
 * JdSmsResp
 *
 * @author fmk
 * @since 2024/3/22
 */
@Data
public class JdSmsResp implements Serializable {

    private static final long serialVersionUID = 7022897259613176233L;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 附加信息(Json形式返回)
     */
    private String attrData;

    public static JdSmsResp buildSuccess(String data) {
        JdSmsResp jdSmsResp = new JdSmsResp();
        jdSmsResp.setSuccess(true);
        jdSmsResp.setAttrData(data);
        return jdSmsResp;
    }

    public static JdSmsResp buildError(String errorMsg) {
        JdSmsResp jdSmsResp = new JdSmsResp();
        jdSmsResp.setSuccess(false);
        jdSmsResp.setErrorMsg(errorMsg);
        return jdSmsResp;
    }

}
