package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 荣数下单查询返回 code 枚举
 *
 * @author wangguanhua
 */
@RequiredArgsConstructor
@Getter
public enum RongshuCodeEnum {

    SUCCESS(10000, "处理成功"),
    PROCESSING(10001, "处理中"),

    /**
     * 查询失败都是50000，根据文案单独判断处理
     */
    NOT_EXIST(50000, "订单不存在");

    private static final Map<Integer, RongshuCodeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(RongshuCodeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    private final Integer code;
    private final String desc;

    /**
     * 根据枚举code获取枚举
     *
     * @param code 枚举code
     * @return 枚举
     */
    public static RongshuCodeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

}
