package cn.com.duiba.supplier.channel.service.api.dto.request.alipay;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/1/13 17:54
 */
@Data
public class FuAoChenRongAlipayTransferReq implements Serializable {
    
    private static final long serialVersionUID = 6456788282321083331L;

    /**
     * 商户编号
     */
    private String merchantNo;

    /**
     * 转账金额，单位为分
     */
    private Long transferAmount;

    /**
     * 收款方账户
     */
    private String payeeAccount;

    /**
     * 收款方姓名（支付宝登录账号或银行卡时必填）
     */
    private String payeeName;

    /**
     * 收款方类型(详细见附件转账类型)
     * @see cn.com.duiba.supplier.channel.service.api.enums.channel.FuAoChenRongPayeeTypeEnum#name()
     */
    private String payeeType;

    /**
     * 订单标题
     */
    private String orderTitle;

    /**
     * 转账备注（默认平台转账）
     */
    private String transferRemark;

    /**
     * 付款方展示名
     */
    private String payerShowName;
    
}
