package cn.com.duiba.supplier.channel.service.api.remoteservice.douyin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.DouYinOauthAccessTokenResp;

/**
 * @author nongfu
 * @Date 2025/6/17 21:05
 */
@AdvancedFeignClient
public interface RemoteDouYinBaseService {

    /**
     * 通过code 和 appID 获取accessToken
     * @param appid appID (client_key)
     * @param code code
     * @return 请求失败返回 null
     */
    DouYinOauthAccessTokenResp getAccessToken(String appid, String code);

    /**
     * 获取jsb_ticket
     * @param appid (client_key)
     * @param accessToken 接口调用凭证
     * @return ticket
     */
    String getJsbTicket(String appid, String accessToken);

    /**
     * 生成 client_token
     * @param appid (client_key)
     * @return access_token
     */
    String getClientToken(String appid);


}
